//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Enums
//:
//: ## Task:
//:
//: Refactor the code below.
//:
//: Use a switch statement on the optional enum for each exam result instead of optional binding.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// declare an array of optionals using the long-form method
let finalYearExamScores: [Optional<Int>] = [.some(75), .some(43), .none, .some(90), .some(87), .some(12), .none]

// sum all the scores together
var sumOfFinalYearExamScores = 0
finalYearExamScores.forEach { examResult in
    // TODO: Refactor the optional binding code below into a switch statment
    if case .some(let unwrappedTestScore) = examResult {
        sumOfFinalYearExamScores += unwrappedTestScore
    }
}

// print the final result
print("Final Year Score: \(sumOfFinalYearExamScores)")


//:
//: -------------------
//:
//: ## Task:
//:
//: The code below uses the more usual short-form method to extract a value using optional binding.
//:
//: Perform the same task as you did on the code above (which uses long-form) on the code below.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// declare an array of optionals using the short-form method
let finalYearExamScores2: [Int?] = [75, 43, nil, 90, 87, 12, nil]

// sum all the scores together
var sumOfFinalYearExamScores2 = 0
finalYearExamScores2.forEach { examResult in
    // TODO: Refactor the optional binding code below into a switch statment
    if let unwrappedTestScore = examResult {
        sumOfFinalYearExamScores2 += unwrappedTestScore
    }
}

// print the final result
print("Final Year Score: \(sumOfFinalYearExamScores2)")

